function R=rowcomp(A)
% function R=rowcomp(A)
% computes a rowcompressed version of A
% U'A=SV'    where A=USV' is the svd-decomposition of A
bigeps=1e6*eps;
[U,S,V]=svd(A);
r=rank(S,bigeps);
if r>0
   R(1:r,:)=S(1:r,:)*V';
else
   R=[];
end;
