function B=kertoim(A,dim)
% B=kertoim(A,dim)
% transforms an Ker-form given by A to a Im-form given by B
% Im(V2')=ker(A)
% Warning: kertoim([],dim)=eye(dim)                                   
if size(A)==0
   B=eye(dim);
else
   bigeps=1e+6*eps;
   [U,S,V]=svd(A);
   r=rank(S,bigeps);
   if r<size(V) 
      B(:,1:size(V)-r)=V(:,r+1:size(V));
   else
      B=[];
   end;
end;
