function B=imtoker(A,dim)
% B=imtoker(A,dim)
% transforms an Im-form given by A to a Ker-form given by B
% ker(U2') = Im(A)
% Warning: imtoker([],dim)=eye(dim)
if size(A)==0
   B=eye(dim);                                                        
else
   bigeps=1e+6*eps;
   [U,S,V]=svd(A);
   r=rank(S,bigeps);
   if r<size(U)
      B(1:size(U)-r,:)=U(:,r+1:size(U))';
   else 
      B=[];
   end;
end;

