function F=feedb(A,B,V)
% function F=feedb(A,B,V)
% calculates a feedback vector F such that (A+BF)V C V
% B and V should be given in Im-form
% Note: One must have AV C V+B  
if subset(A*V,[V B])
   [vr vc]=size(V);
   [br bc]=size(B);
   XZ=pinv([V B])*(A*V);
   Z=XZ(vc+1:vc+bc,:);
   F=-Z*(pinv(V')');
else
   disp('Warning: V is not (A,B)-invariant');
end;

